<?php

class EWRporta_Model_Modules extends XenForo_Model
{
	public function getModuleByName($modName)
	{
		if (!$module = $this->_getDb()->fetchRow("
			SELECT *
				FROM EWRporta_modules
			WHERE module_name = ?
		", $modName))
		{
			return false;
		}

		return $module;
	}

	public function getModules($getCache = true)
	{
		$modules = $this->_getDb()->fetchAll("
			SELECT *
				FROM EWRporta_modules
			ORDER BY module_order ASC
		");

		if ($getCache && $cookies = XenForo_Helper_Cookie::getCookie('EWRporta'))
		{
			$order = array();

			foreach ($modules AS $key => &$module)
			{
				if (!$module['module_locked'] && !empty($cookies[$module['module_name']]['order']) && !empty($cookies[$module['module_name']]['position']))
				{
					$module['module_order'] = $cookies[$module['module_name']]['order'];
					$module['module_position'] = $cookies[$module['module_name']]['position'];
				}

				$order[$key] = $module['module_order'];
			}

			array_multisort($order, SORT_ASC, $modules);
		}

		return $modules;
	}

	public function sortModules($a, $b)
	{
		if ($a['module_order'] == $b['module_order']) { return 0; }
		return ($a['module_order'] < $b['module_order']) ? -1 : 1;
	}

	public function updateModules($modules)
	{
		$order = 0;

		foreach ($modules AS $key => $module)
		{
			$dw = XenForo_DataWriter::create('EWRporta_DataWriter_Modules');
			$dw->setExistingData(array('module_name' => $key));
			$dw->bulkSet(array(
				'module_order' => $order++,
				'module_position' => $module,
			));
			$dw->save();
		}

		return true;
	}

	public function importModule($fileName)
	{
		if (!file_exists($fileName) || !is_readable($fileName))
		{
			throw new XenForo_Exception(new XenForo_Phrase('please_enter_valid_file_name_requested_file_not_read'), true);
		}

		$file = new SimpleXMLElement($fileName, null, true);

		if ($file->getName() != 'module')
		{
			throw new XenForo_Exception(new XenForo_Phrase('provided_file_is_not_a_module_xml_file'), true);
		}

		if (!$module = $this->getModuleByName($file->module_name))
		{
			$dw = XenForo_DataWriter::create('EWRporta_DataWriter_Modules');
			$dw->bulkSet(array(
				'module_name' => $file->module_name,
				'module_cache' => $file->module_cache,
			));
			$dw->save();
		}

		foreach ($file->module_settings->children() AS $key => $setting)
		{
			if (!stristr($key, $file->module_name.'_'))
			{
				$key = strtolower($file->module_name).'_'.$key;
			}

			$attributes = $setting->attributes();

			$dw2 = XenForo_DataWriter::create('EWRporta_DataWriter_Settings');
			if ($exist = $this->getModelFromCache('EWRporta_Model_Settings')->getSettingByName($key))
			{
				$dw2->setExistingData($exist);
				$setting = $exist['setting_value'];
			}
			$dw2->bulkSet(array(
				'module_name' => $file->module_name,
				'setting_name' => $key,
				'setting_value' => $setting,
				'setting_desc' => $attributes->desc,
				'setting_format' => $attributes->format,
			));
			$dw2->save();
		}

		$className = 'EWRporta_Block_'.$file->module_name;
		$dw3 = XenForo_DataWriter::create('XenForo_DataWriter_Template');
		if ($template = $this->getModelFromCache('XenForo_Model_Template')->getTemplateInStyleByTitle($className))
		{
			$dw3->setExistingData($template);
		}
		$dw3->bulkSet(array(
			'title' => $className,
			'template' => $file->module_template,
			'style_id' => '0',
		));
		$dw3->save();

		return true;
	}

	public function exportModule($module)
	{
		$className = 'EWRporta_Block_'.$module['module_name'];
		$template = $this->getModelFromCache('XenForo_Model_Template')->getTemplateInStyleByTitle($className);
		$settings = $this->getModelFromCache('EWRporta_Model_Settings')->getSettingsByModule($module['module_name']);

		$document = new DOMDocument('1.0', 'utf-8');
		$document->formatOutput = true;

		$mod_node = $document->createElement('module');
		$document->appendChild($mod_node);

		$mod_node->appendChild($document->createElement('module_name', $module['module_name']));
		$mod_node->appendChild($document->createElement('module_cache', $module['module_cache']));

		$set_node = $document->createElement('module_settings');
		foreach ($settings AS $setting)
		{
			$setting['setting_name'] = str_ireplace($module['module_name'].'_', '', $setting['setting_name']);

			$sts_node = $document->createElement($setting['setting_name'], $setting['setting_value']);
			$sts_node->setAttribute('desc', $setting['setting_desc']);
			$sts_node->setAttribute('format', $setting['setting_format']);
			$set_node->appendChild($sts_node);
		}
		$mod_node->appendChild($set_node);

		$con_node = $document->createElement('module_template', '');
		$con_node->appendChild($document->createCDATASection($template['template']));
		$mod_node->appendChild($con_node);

		return $document;
	}

	public function deleteModule($module)
	{
		$className = 'EWRporta_Block_'.$module['module_name'];
		$template = $this->getModelFromCache('XenForo_Model_Template')->getTemplateInStyleByTitle($className);

		$dw = XenForo_DataWriter::create('EWRporta_DataWriter_Modules');
		$dw->setExistingData($module);
		$dw->delete();

		$this->_getDb()->query("DELETE FROM EWRporta_cache WHERE module_name = ?", $module['module_name']);
		$this->_getDb()->query("DELETE FROM EWRporta_settings WHERE module_name = ?", $module['module_name']);

		$dw2 = XenForo_DataWriter::create('XenForo_DataWriter_Template');
		$dw2->setExistingData($template);
		$dw2->delete();

		return true;
	}
}